 /* 'mrRGBAImage.h' */

 /* Nagwek typw bazowych Mirus */
#include "mrDatatypes.h"
 /* Nagwek definicji bdw Mirus */
#include "mrError.h"
 /* Nagwek Windows */
#include <windows.h> 
 /* Nagowek strumienia pliku */
#include <fstream.h>
 /* Plik nagwka grafiki DirectX */
#include <d3d8.h> 

 /* Zacz ten plik tylko raz */
#pragma once

 /* Klasa obrazu RGBA biblioteki Mirus */
class mrRGBAImage
{
protected:
  /* Rozmiar obrazu */
 mrUInt32        m_iWidth;
 mrUInt32        m_iHeight;

  /* Bufor obrazu */
 mrUInt32 *      m_piImageBuffer;
 
public:
  /* Konstruktor / Destruktor */
 mrRGBAImage (void);
 ~mrRGBAImage (void);

  /* Operatory */
 mrRGBAImage & operator = (mrRGBAImage & rkImage);

  /* adowanie obrazu z mapy bitowej Windows */
 mrError32 LoadFromBitmap (LPSTR lpszFilename);
 mrError32 LoadFromTarga (LPSTR lpszFilename);

  /* Manipulacja obrazem */
 void SetColorKey (mrUInt8 iRed, mrUInt8 iGreen, mrUInt8 iBlue);

 void SetWidth (mrUInt32);
 void SetHeight (mrUInt32);
 void SetColor (mrUInt32 iX, mrUInt32 iY, mrUInt8 iRed, 
                mrUInt8 iGreen, mrUInt8 iBlue, 
                mrUInt8 iAlpha);
 void SetImageBuffer (mrUInt32 * pImage);

 mrUInt32 GetWidth (void);
 mrUInt32 GetHeight (void);
 mrUInt32 GetColor (mrUInt32 iX, mrUInt32 iY);
 mrUInt32 * GetImageBuffer (void);
};
